/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy.lang;

import edu.princeton.toy.lang.TException;
import edu.princeton.toy.lang.TExceptionHandler;
import edu.princeton.toy.lang.TExceptionType;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;

public class TWord {
    public static final int BIT_COUNT = 16;
    public static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String[] HEX_PAIRS = new String[256];
    private static final Reference[] CACHED_REFERENCES = new Reference[65536];
    public static final TWord UNINITIALIZED_VALUE = new TWord();
    public static final TWord MIN_VALUE = new TWord(Short.MIN_VALUE);
    public static final TWord MAX_VALUE = new TWord(Short.MAX_VALUE);
    public static final TWord ZERO = new TWord(0);
    public static final TWord ONE = new TWord(1);
    private short value;
    private boolean isInitialized;
    private String binaryString;
    private String formattedBinaryString;
    private String decimalString;
    private String hexString;
    private String pseudoCodeString;
    private String detailedString;

    private TWord(short value) {
        int ctr;
        char op = HEX_DIGITS[value >> 12 & 0xF];
        char d = HEX_DIGITS[value >> 8 & 0xF];
        char s = HEX_DIGITS[value >> 4 & 0xF];
        char t = HEX_DIGITS[value & 0xF];
        this.value = value;
        this.isInitialized = true;
        StringBuffer buffer = new StringBuffer(160);
        for (ctr = 15; ctr >= 0; --ctr) {
            if ((value >> ctr & 1) != 0) {
                buffer.append('1');
                continue;
            }
            buffer.append('0');
        }
        this.binaryString = buffer.toString();
        buffer.delete(0, buffer.length());
        for (ctr = 15; ctr >= 0; --ctr) {
            if (ctr != 15 && ctr % 4 == 3) {
                buffer.append(' ');
            }
            if ((value >> ctr & 1) != 0) {
                buffer.append('1');
                continue;
            }
            buffer.append('0');
        }
        this.formattedBinaryString = buffer.toString();
        buffer.delete(0, buffer.length());
        this.decimalString = String.valueOf(value);
        for (ctr = this.decimalString.length(); ctr < 6; ++ctr) {
            buffer.append(' ');
        }
        buffer.append(this.decimalString);
        this.decimalString = buffer.toString();
        buffer.delete(0, buffer.length());
        buffer.append(op);
        buffer.append(d);
        buffer.append(s);
        buffer.append(t);
        this.hexString = buffer.toString();
        switch (op) {
            case '0': {
                this.pseudoCodeString = "halt";
                break;
            }
            case '1': {
                if (d == '0') {
                    this.pseudoCodeString = "no-op";
                    break;
                }
                if (s == '0' && d == t) {
                    this.pseudoCodeString = "no-op";
                    break;
                }
                if (t == '0' && d == s) {
                    this.pseudoCodeString = "no-op";
                    break;
                }
                if (s == '0' && t != '0') {
                    this.pseudoCodeString = "R[" + d + "] <- R[" + t + "]";
                    break;
                }
                if (s != '0' && t == '0') {
                    this.pseudoCodeString = "R[" + d + "] <- R[" + s + "]";
                    break;
                }
                if (s == '0' && t == '0') {
                    this.pseudoCodeString = "R[" + d + "] <- 0000";
                    break;
                }
                this.pseudoCodeString = "R[" + d + "] <- R[" + s + "] + R[" + t + "]";
                break;
            }
            case '2': {
                if (d == '0') {
                    this.pseudoCodeString = "no-op";
                    break;
                }
                if (t == '0' && d == s) {
                    this.pseudoCodeString = "no-op";
                    break;
                }
                if (s == '0' && t != '0') {
                    this.pseudoCodeString = "R[" + d + "] <- -R[" + t + "]";
                    break;
                }
                if (s != '0' && t == '0') {
                    this.pseudoCodeString = "R[" + d + "] <- R[" + s + "]";
                    break;
                }
                if (s == '0' && t == '0') {
                    this.pseudoCodeString = "R[" + d + "] <- 0000";
                    break;
                }
                this.pseudoCodeString = "R[" + d + "] <- R[" + s + "] - R[" + t + "]";
                break;
            }
            case '3': {
                if (d == '0') {
                    this.pseudoCodeString = "no-op";
                    break;
                }
                if (d == s && s == t) {
                    this.pseudoCodeString = "no-op";
                    break;
                }
                if (s == '0' || t == '0') {
                    this.pseudoCodeString = "R[" + d + "] <- 0000";
                    break;
                }
                if (s == t) {
                    this.pseudoCodeString = "R[" + d + "] <- R[" + s + "]";
                    break;
                }
                this.pseudoCodeString = "R[" + d + "] <- R[" + s + "] & R[" + t + "]";
                break;
            }
            case '4': {
                if (d == '0') {
                    this.pseudoCodeString = "no-op";
                    break;
                }
                if (s == '0' && t != '0') {
                    this.pseudoCodeString = "R[" + d + "] <- R[" + t + "]";
                    break;
                }
                if (s != '0' && t == '0') {
                    this.pseudoCodeString = "R[" + d + "] <- R[" + s + "]";
                    break;
                }
                if (s == '0' && t == '0') {
                    this.pseudoCodeString = "R[" + d + "] <- 0000";
                    break;
                }
                this.pseudoCodeString = "R[" + d + "] <- R[" + s + "] ^ R[" + t + "]";
                break;
            }
            case '5': {
                if (d == '0') {
                    this.pseudoCodeString = "no-op";
                    break;
                }
                if (t == '0' && d == s) {
                    this.pseudoCodeString = "no-op";
                    break;
                }
                if (s == '0') {
                    this.pseudoCodeString = "R[" + d + "] <- 0000";
                    break;
                }
                if (t == '0') {
                    this.pseudoCodeString = "R[" + d + "] <- R[" + s + "]";
                    break;
                }
                this.pseudoCodeString = "R[" + d + "] <- R[" + s + "] << R[" + t + "]";
                break;
            }
            case '6': {
                if (d == '0') {
                    this.pseudoCodeString = "no-op";
                    break;
                }
                if (t == '0' && d == s) {
                    this.pseudoCodeString = "no-op";
                    break;
                }
                if (s == '0') {
                    this.pseudoCodeString = "R[" + d + "] <- 0000";
                    break;
                }
                if (t == '0') {
                    this.pseudoCodeString = "R[" + d + "] <- R[" + s + "]";
                    break;
                }
                this.pseudoCodeString = "R[" + d + "] <- R[" + s + "] >> R[" + t + "]";
                break;
            }
            case '7': {
                if (d == '0') {
                    this.pseudoCodeString = "no-op";
                    break;
                }
                this.pseudoCodeString = "R[" + d + "] <- 00" + s + t;
                break;
            }
            case '8': {
                if (s == 'F' && t == 'F') {
                    this.pseudoCodeString = "read R[" + d + "]";
                    break;
                }
                if (d == '0') {
                    this.pseudoCodeString = "no-op";
                    break;
                }
                this.pseudoCodeString = "R[" + d + "] <- M[" + s + t + "]";
                break;
            }
            case '9': {
                if (s == 'F' && t == 'F') {
                    this.pseudoCodeString = "write R[" + d + "]";
                    break;
                }
                this.pseudoCodeString = "M[" + s + t + "] <- R[" + d + "]";
                break;
            }
            case 'A': {
                if (d == '0') {
                    this.pseudoCodeString = "no-op";
                    break;
                }
                this.pseudoCodeString = "R[" + d + "] <- M[R[" + t + "]]";
                break;
            }
            case 'B': {
                this.pseudoCodeString = "M[R[" + t + "]] <- R[" + d + "]";
                break;
            }
            case 'C': {
                if (d == '0') {
                    this.pseudoCodeString = "goto " + s + t;
                    break;
                }
                this.pseudoCodeString = "if (R[" + d + "] == 0) goto " + s + t;
                break;
            }
            case 'D': {
                if (d == '0') {
                    this.pseudoCodeString = "no-op";
                    break;
                }
                this.pseudoCodeString = "if (R[" + d + "] > 0) goto " + s + t;
                break;
            }
            case 'E': {
                this.pseudoCodeString = "goto R[" + d + "]";
                break;
            }
            case 'F': {
                if (d == '0') {
                    this.pseudoCodeString = "goto " + s + t;
                    break;
                }
                this.pseudoCodeString = "R[" + d + "] <- PC; goto " + s + t;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        buffer.delete(0, buffer.length());
        buffer.append(this.hexString);
        buffer.append(" (");
        buffer.append(this.formattedBinaryString);
        buffer.append(", ");
        buffer.append(this.decimalString);
        buffer.append(')');
        this.detailedString = buffer.toString();
    }

    private TWord() {
        this(0);
        this.isInitialized = false;
    }

    public static boolean isCommand(String cmd) {
        if (cmd.length() != 8) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            if (!(i >= 2 && i <= 3 || TWord.isHexDigit(cmd.charAt(i)))) {
                return false;
            }
            if (i == 2 && cmd.charAt(i) != ':') {
                return false;
            }
            if (i != 3 || cmd.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public static String commentLine(String line) {
        String pseudoCodeString;
        int lineLength = line.length();
        int extraStart = 8;
        int end = 41;
        if (end > lineLength) {
            end = lineLength;
        }
        String extra = "";
        if (TWord.isPseudoCode(line.substring(8, end))) {
            extraStart = end;
        }
        if (lineLength > extraStart) {
            extra = line.substring(extraStart, lineLength);
        }
        int arrayLength = 33;
        char[] array = new char[arrayLength];
        if (line.charAt(0) == '0' && line.charAt(1) >= '0' && line.charAt(1) <= 'F') {
            pseudoCodeString = "constant 0x" + line.substring(4, 8);
        } else {
            TWord command = TWord.parseWord(line.substring(4, 8), 16);
            pseudoCodeString = command.toPseudoCodeString(false);
        }
        int pseudoCodeStringLength = pseudoCodeString.length();
        pseudoCodeString.getChars(0, pseudoCodeStringLength, array, 3);
        array[0] = 32;
        array[1] = 32;
        array[2] = 32;
        for (int ctr = pseudoCodeStringLength + 3; ctr < arrayLength; ++ctr) {
            array[ctr] = 32;
        }
        return line.substring(0, 8) + new String(array) + extra;
    }

    public static boolean isPseudoCode(String str) {
        boolean match = (str = str.trim()).matches("constant 0x[0-9A-F][0-9A-F][0-9A-F][0-9A-F]") || str.matches("R\\[[0-9A-F]] <- R\\[[0-9A-F]] ([+\\-&^]|<<|>>) R\\[[0-9A-F]]") || str.matches("((read)|(write)) R\\[[0-9A-F]]") || str.matches("goto [0-9A-F][0-9A-F]") || str.matches("R\\[[0-9A-F]] <- PC; goto [0-9A-F][0-9A-F]") || str.matches("R\\[[0-9A-F]] <- 00[0-9A-F][0-9A-F]") || str.matches("R\\[[0-9A-F]] <- M\\[[0-9A-F][0-9A-F]]") || str.matches("M\\[[0-9A-F][0-9A-F]] <- R\\[[0-9A-F]]") || str.matches("R\\[[0-9A-F]] <- M\\[R\\[[0-9A-F]]]") || str.matches("M\\[R\\[[0-9A-F]]] <- R\\[[0-9A-F]]") || str.matches("if \\(R\\[[0-9A-F]] ((==)|>) 0\\) goto [0-9A-F][0-9A-F]") || str.matches("goto R\\[[0-9A-F]]") || str.matches("R\\[[0-9A-F]] <- R\\[[0-9A-F]]") || str.matches("R\\[[0-9A-F]] <- -R\\[[0-9A-F]]") || str.equals("halt") || str.equals("no-op");
        return match;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public short getValue() {
        return this.value;
    }

    public byte getOp() {
        return (byte)(this.value >> 12 & 0xF);
    }

    public byte getD() {
        return (byte)(this.value >> 8 & 0xF);
    }

    public byte getS() {
        return (byte)(this.value >> 4 & 0xF);
    }

    public byte getT() {
        return (byte)(this.value >> 0 & 0xF);
    }

    public TWord initializedValue() {
        if (!this.isInitialized) {
            return ZERO;
        }
        return this;
    }

    public short getImm() {
        return (short)(this.value >> 0 & 0xFF);
    }

    public static TWord getWord(short value) {
        TWord answer = null;
        Reference reference = CACHED_REFERENCES[value - Short.MIN_VALUE];
        if (reference == null) {
            answer = new TWord(value);
            TWord.CACHED_REFERENCES[value - Short.MIN_VALUE] = new SoftReference<TWord>(answer);
        } else {
            answer = (TWord)reference.get();
            if (answer == null) {
                answer = new TWord(value);
                TWord.CACHED_REFERENCES[value - Short.MIN_VALUE] = new SoftReference<TWord>(answer);
            }
        }
        return answer;
    }

    public static TWord parseWord(String string, int radix) throws NumberFormatException {
        int n = Integer.parseInt(string, radix);
        if ((n & 0xFFFF0000) != 0 && (n & 0xFFFF0000) != -65536) {
            throw new NumberFormatException();
        }
        return TWord.getWord((short)n);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TWord) {
            return ((TWord)obj).isInitialized == this.isInitialized && ((TWord)obj).value == this.value;
        }
        return false;
    }

    public String toBinaryString(boolean distinguishUninitialized) {
        if (this.isInitialized || !distinguishUninitialized) {
            return this.binaryString;
        }
        return "????????????????";
    }

    public String toFormattedBinaryString(boolean distinguishUninitialized) {
        if (this.isInitialized || !distinguishUninitialized) {
            return this.formattedBinaryString;
        }
        return "???? ???? ???? ????";
    }

    public String toDecimalString(boolean distinguishUninitialized) {
        if (this.isInitialized || !distinguishUninitialized) {
            return this.decimalString;
        }
        return "??????";
    }

    public String toHexString(boolean distinguishUninitialized) {
        if (this.isInitialized || !distinguishUninitialized) {
            return this.hexString;
        }
        return "????";
    }

    public String toString() {
        return this.detailedString;
    }

    public String toString(boolean distinguishUninitialized) {
        if (this.isInitialized || !distinguishUninitialized) {
            return this.detailedString;
        }
        return "???? (Uninitialized Value)";
    }

    public String toPseudoCodeString(boolean distinguishUninitialized) {
        if (this.isInitialized || !distinguishUninitialized) {
            return this.pseudoCodeString;
        }
        return "Uninitialized Value";
    }

    public static TWord add(TWord a, TWord b, TExceptionHandler exceptionHandler) throws TException {
        int sum = a.value + b.value;
        if (!(a.isInitialized && b.isInitialized || exceptionHandler == null)) {
            exceptionHandler.raise(TExceptionType.REGISTER_UNINITIALIZED);
        }
        if ((sum < Short.MIN_VALUE || sum > Short.MAX_VALUE) && exceptionHandler != null) {
            exceptionHandler.raise(TExceptionType.OVERFLOW);
        }
        return TWord.getWord((short)sum);
    }

    public static TWord subtract(TWord a, TWord b, TExceptionHandler exceptionHandler) throws TException {
        int difference;
        if (!(a.isInitialized && b.isInitialized || exceptionHandler == null)) {
            exceptionHandler.raise(TExceptionType.REGISTER_UNINITIALIZED);
        }
        if (((difference = a.value - b.value) < Short.MIN_VALUE || difference > Short.MAX_VALUE) && exceptionHandler != null) {
            exceptionHandler.raise(TExceptionType.OVERFLOW);
        }
        return TWord.getWord((short)difference);
    }

    public static TWord and(TWord a, TWord b, TExceptionHandler exceptionHandler) throws TException {
        if (!(a.isInitialized() && b.isInitialized() || exceptionHandler == null)) {
            exceptionHandler.raise(TExceptionType.REGISTER_UNINITIALIZED);
        }
        return TWord.getWord((short)(a.getValue() & b.getValue()));
    }

    public static TWord xor(TWord a, TWord b, TExceptionHandler exceptionHandler) throws TException {
        if (!(a.isInitialized() && b.isInitialized() || exceptionHandler == null)) {
            exceptionHandler.raise(TExceptionType.REGISTER_UNINITIALIZED);
        }
        return TWord.getWord((short)(a.getValue() ^ b.getValue()));
    }

    public static TWord leftShift(TWord a, TWord b, TExceptionHandler exceptionHandler) throws TException {
        if (!(a.isInitialized() && b.isInitialized() || exceptionHandler == null)) {
            exceptionHandler.raise(TExceptionType.REGISTER_UNINITIALIZED);
        }
        if ((b.getValue() & 0xF) != b.getValue() && exceptionHandler != null) {
            exceptionHandler.raise(TExceptionType.SHIFT_OUT_OF_BOUNDS);
        }
        return TWord.getWord((short)(a.getValue() << (b.getValue() & 0xF)));
    }

    public static TWord rightShift(TWord a, TWord b, TExceptionHandler exceptionHandler) throws TException {
        if (!(a.isInitialized() && b.isInitialized() || exceptionHandler == null)) {
            exceptionHandler.raise(TExceptionType.REGISTER_UNINITIALIZED);
        }
        if ((b.getValue() & 0xF) != b.getValue() && exceptionHandler != null) {
            exceptionHandler.raise(TExceptionType.SHIFT_OUT_OF_BOUNDS);
        }
        return TWord.getWord((short)(a.getValue() >> (b.getValue() & 0xF)));
    }

    public static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static int hexDigitToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException();
    }

    static {
        TWord.CACHED_REFERENCES[0] = new SoftReference<TWord>(MIN_VALUE);
        TWord.CACHED_REFERENCES[32768] = new SoftReference<TWord>(ZERO);
        TWord.CACHED_REFERENCES[32769] = new SoftReference<TWord>(ONE);
        TWord.CACHED_REFERENCES[65535] = new SoftReference<TWord>(MAX_VALUE);
        for (int ctr1 = 0; ctr1 < 16; ++ctr1) {
            String firstDigit = String.valueOf(HEX_DIGITS[ctr1]);
            for (int ctr2 = 0; ctr2 < 16; ++ctr2) {
                TWord.HEX_PAIRS[ctr1 << 4 | ctr2] = firstDigit + HEX_DIGITS[ctr2];
            }
        }
    }
}

